<?php

class especial_Model_DbTable_Escolagrade extends Zsam_Db_Table {

	protected $_name 	= 'escolagrade';
	var $_autocomplet 	= array('ID','ANO','SEMESTRE','TURNO','EMPRESA') ;
 	var $_conf = array(
 			'ID' 				=> array("grid"=>true,'edit'=>'N'),
 			'EMPRESA' 			=> array("grid"=>true,'NULLABLE' => false),
 			'CURSO' 			=> array("grid"=>true,'NULLABLE' => false),
 			'ANO' 				=> array("grid"=>true,'NULLABLE' => false,"VP"=> array(2013=>'2013',2014=>'2014',2015=>'2015',2016=>'2016',2017=>'2017',2018=>'2018',2019=>'2019',2020=>'2020',2021=>'2021',2022=>'2022',2023=>'2023',2024=>'2024',2025=>'2025')),
 			'SEMESTRE' 			=> array("grid"=>true,'NULLABLE' => false,'VP' => '1,2'),
 			'PERIODO' 			=> array("grid"=>true,'NULLABLE' => false,"VP" => array(1=>'I periodo',2=>'II periodo',3=>'III periodo',4=>'IV periodo',5=>'V periodo',6=>'VI periodo')),
 			'TURNO' 			=> array("grid"=>true,'NULLABLE' => false,'VP' => 'MANHA,TARDE,NOITE'),
 			'AULA_SEG_1' 		=> array('autocomplete'=>'Y','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_1'))),
 			'AULA_SEG_2' 		=> array('autocomplete'=>'Y','title'=>'AULA_2','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_2'))),
 			'AULA_SEG_3' 		=> array('autocomplete'=>'Y','title'=>'AULA_3','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_3'))),
 			'AULA_SEG_4' 		=> array('autocomplete'=>'Y','title'=>'AULA_4','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_4'))),
 			'AULA_SEG_5' 		=> array('autocomplete'=>'Y','title'=>'AULA_5','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_5'))),
 			'AULA_SEG_6' 		=> array('autocomplete'=>'Y','title'=>'AULA_6','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_6'))),
 			'AULA_TER_1' 		=> array('autocomplete'=>'Y','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_TER_1'))),
 			'AULA_TER_2' 		=> array('autocomplete'=>'Y','title'=>'AULA_2','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_TER_2'))),
 			'AULA_TER_3' 		=> array('autocomplete'=>'Y','title'=>'AULA_3','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_TER_3'))),
 			'AULA_TER_4' 		=> array('autocomplete'=>'Y','title'=>'AULA_4','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_TER_4'))),
 			'AULA_TER_5' 		=> array('autocomplete'=>'Y','title'=>'AULA_5','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_TER_5'))),
 			'AULA_TER_6' 		=> array('autocomplete'=>'Y','title'=>'AULA_6','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_TER_6'))),
 			'AULA_QUA_1' 		=> array('autocomplete'=>'Y','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUA_1'))),
 			'AULA_QUA_2' 		=> array('autocomplete'=>'Y','title'=>'AULA_2','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUA_2'))),
 			'AULA_QUA_3' 		=> array('autocomplete'=>'Y','title'=>'AULA_3','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUA_3'))),
 			'AULA_QUA_4' 		=> array('autocomplete'=>'Y','title'=>'AULA_4','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUA_4'))),
 			'AULA_QUA_5' 		=> array('autocomplete'=>'Y','title'=>'AULA_5','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUA_5'))),
 			'AULA_QUA_6' 		=> array('autocomplete'=>'Y','title'=>'AULA_6','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUA_6'))),
 			'AULA_QUI_1' 		=> array('autocomplete'=>'Y','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUI_1'))),
 			'AULA_QUI_2' 		=> array('autocomplete'=>'Y','title'=>'AULA_2','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUI_2'))),
 			'AULA_QUI_3' 		=> array('autocomplete'=>'Y','title'=>'AULA_3','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUI_3'))),
 			'AULA_QUI_4' 		=> array('autocomplete'=>'Y','title'=>'AULA_4','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEG_4'))),
 			'AULA_QUI_5' 		=> array('autocomplete'=>'Y','title'=>'AULA_5','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUI_5'))),
 			'AULA_QUI_6' 		=> array('autocomplete'=>'Y','title'=>'AULA_6','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_QUI_6'))),
 			'AULA_SEX_1' 		=> array('autocomplete'=>'Y','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEX_1'))),
 			'AULA_SEX_2' 		=> array('autocomplete'=>'Y','title'=>'AULA_2','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEX_2'))),
 			'AULA_SEX_3' 		=> array('autocomplete'=>'Y','title'=>'AULA_3','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEX_3'))),
 			'AULA_SEX_4' 		=> array('autocomplete'=>'Y','title'=>'AULA_4','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEX_4'))),
 			'AULA_SEX_5' 		=> array('autocomplete'=>'Y','title'=>'AULA_5','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEX_5'))),
 			'AULA_SEX_6' 		=> array('autocomplete'=>'Y','title'=>'AULA_6','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SEX_6'))),
 			'AULA_SAB_1' 		=> array('autocomplete'=>'N','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SAB_1'))),
 			'AULA_SAB_2' 		=> array('autocomplete'=>'Y','title'=>'AULA_2','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SAB_2'))),
 			'AULA_SAB_3' 		=> array('autocomplete'=>'Y','title'=>'AULA_3','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SAB_3'))),
 			'AULA_SAB_4' 		=> array('autocomplete'=>'Y','title'=>'AULA_4','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SAB_4'))),
 			'AULA_SAB_5' 		=> array('autocomplete'=>'Y','title'=>'AULA_5','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SAB_5'))),
 			'AULA_SAB_6' 		=> array('autocomplete'=>'Y','title'=>'AULA_6','validate'=>array('Cisweb_Validate_Escolagrade'=>array("campo"=>'AULA_SAB_6'))),
 			'FUNC_ALTERACAO' 	=> array('edit'=>'N'),
 			'DATA_ALTERACAO' 	=> array('edit'=>'N'),
 			'REVISAO' 			=> array('edit'=>'N'),
 );

 	protected $_referenceMap    = array(

 			'EMPRESA' => array(
 					'columns'           => 'EMPRESA',
 					'refTableClass'     => 'core_Model_DbTable_Empresa',
 					'refColumns'        => 'CODIGO',
 					'refTitle'          => 'EMPRESA'
 			),

 			'CURSO' => array(
 					'columns'           => 'CURSO',
 					'refTableClass'     => 'especial_Model_DbTable_Escolacurso',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'CURSO'
 			),

 			'AULA_SEG_1' => array(
 					'columns'           => 'AULA_SEG_1',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'AULA_SEG_1'
 			),

 			'AULA_SEG_2' => array(
 					'columns'           => 'AULA_SEG_2',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEG_3' => array(
 					'columns'           => 'AULA_SEG_3',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEG_4' => array(
 					'columns'           => 'AULA_SEG_4',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEG_5' => array(
 					'columns'           => 'AULA_SEG_5',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEG_6' => array(
 					'columns'           => 'AULA_SEG_6',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),


 			'AULA_TER_1' => array(
 					'columns'           => 'AULA_TER_1',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_TER_2' => array(
 					'columns'           => 'AULA_TER_2',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_TER_3' => array(
 					'columns'           => 'AULA_TER_3',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_TER_4' => array(
 					'columns'           => 'AULA_TER_4',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_TER_5' => array(
 					'columns'           => 'AULA_TER_5',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_TER_6' => array(
 					'columns'           => 'AULA_SEG_6',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUA_1' => array(
 					'columns'           => 'AULA_QUA_1',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUA_2' => array(
 					'columns'           => 'AULA_QUA_2',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUA_3' => array(
 					'columns'           => 'AULA_QUA_3',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUA_4' => array(
 					'columns'           => 'AULA_QUA_4',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUA_5' => array(
 					'columns'           => 'AULA_QUA_5',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUA_6' => array(
 					'columns'           => 'AULA_QUA_6',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUI_1' => array(
 					'columns'           => 'AULA_QUI_1',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUI_2' => array(
 					'columns'           => 'AULA_QUI_2',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUI_3' => array(
 					'columns'           => 'AULA_QUI_3',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUI_4' => array(
 					'columns'           => 'AULA_QUI_4',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUI_5' => array(
 					'columns'           => 'AULA_QUI_5',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_QUI_6' => array(
 					'columns'           => 'AULA_QUI_6',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),


 			'AULA_SEX_1' => array(
 					'columns'           => 'AULA_SEX_1',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEX_2' => array(
 					'columns'           => 'AULA_SEG_2',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEX_3' => array(
 					'columns'           => 'AULA_SEX_3',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEX_4' => array(
 					'columns'           => 'AULA_SEX_4',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEX_5' => array(
 					'columns'           => 'AULA_SEX_5',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SEX_6' => array(
 					'columns'           => 'AULA_SEX_6',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SAB_1' => array(
 					'columns'           => 'AULA_SAB_1',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SAB_2' => array(
 					'columns'           => 'AULA_SAB_2',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SAB_3' => array(
 					'columns'           => 'AULA_SAB_3',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SAB_4' => array(
 					'columns'           => 'AULA_SAB_4',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SAB_5' => array(
 					'columns'           => 'AULA_SAB_5',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),

 			'AULA_SAB_6' => array(
 					'columns'           => 'AULA_SAB_6',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladiscprof',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),





 	);
	
    public function __construct()
    {
      parent::__construct();

        $controller 	 = Zend_Controller_Front::getInstance()->getRequest();
	    $nome_controller = $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

	    $config		  = new core_Model_DbTable_Config();
		$campos		  = $config->getAdapter()->fetchAll($config->select());
		$datavalidest = $campos[0]['DATAVALIDEST'];
		$ano		  = $campos[0]['DIVERSOS'];
		$semestre	  = $campos[0]['MES'];

	  	if($nome_controller == 'escolagrade')
		{
			$tipo= "ANO = '$ano' AND SEMESTRE = '$semestre'";
			$this->_restrict = $tipo;

//			$this->_conf['NOVO_VENCIMENTO']['grid'] = false;
//			$this->_conf['FORMA_ENVIO']['edit'] 	= 'S';
//			$this->_conf['RECEITA']['grid'] 		= false;
//			$this->_conf['ACP5W2H']['edit'] 		= 'S';
//			$this->_conf['PLANO_CONTA']['NULLABLE']	= false;
		}
		
	}

	public function beforeInsert(array $data)
	{

		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		$table_curso = new Cisweb_Db_Abstract("escolacurso");
		$curso   	 = $data['CURSO'];
		$dados_curso = $table_curso->select()->where("ID = ?",$curso);
		$dados_curso = $table_curso->fetchRow($dados_curso)->toArray();
		$coordenador = @$dados_curso['COORDENADOR'];

		$auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$nivel  = @$user['NIVEL'];
		}

		if($nivel < 4 && $id <> $coordenador){
			echo "<script>alert('Para Alterar, Contatar o Coordenador do Curso')</script>";
			echo "<script>window.location='/cisweb/public/especial/escolagrade'</script>";die;
		}else{
			return parent::beforeInsert($data);
		}	
    }

   	public function beforeUpdate(array $data,$where)
	{

		$table_curso = new Cisweb_Db_Abstract("escolacurso");
		$curso   	 = $data['CURSO'];
		$dados_curso = $table_curso->select()->where("ID = ?",$curso);
		$dados_curso = $table_curso->fetchRow($dados_curso)->toArray();
		$coordenador = @$dados_curso['COORDENADOR'];

		$auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$nivel  = @$user['NIVEL'];
		}

		if($nivel < 4 && $id <> $coordenador){
			echo "<script>alert('Para Incluir, Contatar o Coordenador do Curso')</script>";
			echo "<script>window.location='/cisweb/public/especial/escolagrade'</script>";die;
		}else{
			return parent::beforeUpdate($data,$where);
		}	
		
		
	}

}
?>