<?php

class especial_Model_DbTable_Filedocdb3 extends Zsam_Db_Table {
	
	/**
	 * The default table name 
	 */
    protected $_name = 'filedoc';    
    var $_autocomplet = array('RECURSO','ROTULO_MENU');
    var $_conf = array(
   		'ID' 					=> array('grid' => true,'edit'=>'N'),
    	'RECURSO' 				=> array('case'=>'LOWER','grid' => true, 'cripto'=>'cisweb','NULLABLE' => false),
    	'DESCRICAO' 			=> array('cripto'=>'cisweb'),
    	'ROTULO_MENU' 			=> array('grid' => true,'case'=>'NULL','case'=>'LOWER'),
    	'DISPONIVEL' 			=> array('VP'=>'S,N'),
    	'ORDENACAO' 			=> array('grid' => true,'NULLABLE' => false),
    	'MENU01' 				=> array('level'=>2,'VP'=>'S,N','title' => 'VENDAS'),
    	'MENU02' 				=> array('level'=>2,'VP'=>'S,N','title' => 'PAGAMENTOS'),
    	'MENU03' 				=> array('level'=>2,'VP'=>'S,N','title' => 'COMPRAS'),
    	'MENU04' 				=> array('level'=>2,'VP'=>'S,N','title' => 'ESTOQUE'),
    	'MENU05' 				=> array('level'=>2,'VP'=>'S,N','title' => 'ENGENHARIA'),
    	'MENU06' 				=> array('level'=>2,'VP'=>'S,N','title' => 'PRODUCAO'),
    	'MENU07' 				=> array('level'=>2,'VP'=>'S,N','title' => 'QUALIDADE'),
    	'MENU08' 				=> array('level'=>2,'VP'=>'S,N','title' => 'CONTABILIDADE'),
    	'MENU09' 				=> array('level'=>2,'VP'=>'S,N','title' => 'RH'),
    	'MENU10' 				=> array('level'=>2,'VP'=>'S,N','title' => 'B2B'),
    	'MENU11' 				=> array('level'=>2,'VP'=>'S,N','title' => 'TREINAMENTO'),
    	'MENU12' 				=> array('level'=>2,'VP'=>'S,N','title' => 'CONFIGURACOES'),
    	'MANUAIS' 				=> array('VP'=>'S,N'),
    	'LAN_BASICO' 			=> array('VP'=>'S,N'),
    	'LAN_AVANCADO' 			=> array('VP'=>'S,N'),
    	'REL_BASICO' 			=> array('VP'=>'S,N'),
    	'REL_AVANCADO' 			=> array('VP'=>'S,N'),
    	'MENU_ADM' 				=> array('level'=>2,'VP'=>'S,N'),
    	'MENU_IND' 				=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_AHP'			=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_APS' 			=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_CTN'			=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_COMPRASVMI'		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_DEMANDA' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_ESTOQUE' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_ESTOQUE6SIGMA'	=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_FINAN' 			=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_FISCAL' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_MANUAL' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_PRODUCAO' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_PROJETOS' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_PROJETOS6SIGMA' => array('level'=>2,'VP'=>'S,N'),
    	'MODULO_QUALIDADE' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_RH' 			=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_TREINAMENTO' 	=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_VENDAS' 		=> array('level'=>2,'VP'=>'S,N'),
    	'MODULO_ADMIN' 			=> array('level'=>2,'VP'=>'S,N'),
    	'DATA_ALTERACAO'		=> array('edit'=>'N'),
    	'FUNC_ALTERACAO'		=> array('edit'=>'N'),
    	'REVISAO' 				=> array('edit'=>'N'),
    	'DATASINC' 				=> array('edit'=>'N'),
    );    
	public function getMenuAccess($user,$menu){
		$menuacess=array();
		if ($user['M1']=='S') $menuacess[]='MENU01';
		if ($user['M2']=='S') $menuacess[]='MENU02';
		if ($user['M3']=='S') $menuacess[]='MENU03';
		if ($user['M4']=='S') $menuacess[]='MENU04';
		if ($user['M5']=='S') $menuacess[]='MENU05';
		if ($user['M6']=='S') $menuacess[]='MENU06';
		if ($user['M7']=='S') $menuacess[]='MENU07';
		if ($user['M8']=='S') $menuacess[]='MENU08';
		if ($user['M9']=='S') $menuacess[]='MENU09';
		if ($user['M10']=='S') $menuacess[]='MENU10';
		if ($user['M11']=='S') $menuacess[]='MENU11';
		if ($user['M12']=='S') $menuacess[]='MENU12';
		if (count($menuacess)==0)
		   return array();

		$session = new Zend_Session_Namespace('processo');
		$select = $this->select(true);
		$select->join('filedoc2','filedoc.id=filedoc2.id_file',array())
		->where($menu." = 'S'")
		->where("DISPONIVEL = 'S'")
		->where("'S' in (".implode(',', $menuacess).")")
		->where("filedoc2.id_processo=?",intval($session->proc))
		->order('ORDENACAO');
		if ( $user['ACESSORESTRITO']=='N' )
			$select->where(" 'S' in (MENU_IND) ");
		if ( $user['ACESSORESTRITO']=='P' )
			$select->where(" 'S' in (MENU_ADM,MENU_IND) ");	
			
	    $cliente = Zend_Registry::get('Cliente');

		/*$result = array( 
				  'MENU01'=>array("label"=>"VENDAS","uri"=>"/"),
		          'MENU02'=>array("label"=>"PAGAMENTOS","uri"=>"/"),
		   	   	  'MENU03'=>array("label"=>"COMPRAS","uri"=>"/"),
		   	   	  'MENU04'=>array("label"=>"ESTOQUE","uri"=>"/"),
		          'MENU05'=>array("label"=>"ENGENHARIA","uri"=>"/"),
			      'MENU06'=>array("label"=>"PRODU","uri"=>"/"), 
		   	   	  'MENU07'=>array("label"=>"QUALIDADE","uri"=>"/"),
		   	   	  'MENU08'=>array("label"=>"CONTABILIDADE","uri"=>"/"),
		   	   	  'MENU09'=>array("label"=>"RH","uri"=>"/"),
		   	   	  'MENU10'=>array("label"=>"B2B","uri"=>"/"),
		   	   	  'MENU11'=>array("label"=>"TREINAMENTO","uri"=>"/"),
		   	   	  'MENU12'=>array("label"=>"CONFIGURAÇÕES","uri"=>"/"));*/
		
		
		
		if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$result = array( 
				  'MENU01'=>array("label"=>"VENDAS","uri"=>"/"),
		          'MENU02'=>array("label"=>"PAGAMENTOS","uri"=>"/"),
		   	   	  'MENU03'=>array("label"=>"COMPRAS","uri"=>"/"),
		   	   	  'MENU04'=>array("label"=>"ESTOQUE","uri"=>"/"),
		          'MENU05'=>array("label"=>"ENGENHARIA","uri"=>"/"),
			      'MENU06'=>array("label"=>"PRODUCAO","uri"=>"/"), 
		   	   	  'MENU07'=>array("label"=>"QUALIDADE","uri"=>"/"),
		   	   	  'MENU08'=>array("label"=>"CONTABILIDADE","uri"=>"/"),
		   	   	  'MENU09'=>array("label"=>"RH","uri"=>"/"),
		   	   	  'MENU10'=>array("label"=>"B2B","uri"=>"/"),
		   	   	  'MENU11'=>array("label"=>"TREINAMENTO","uri"=>"/"),
		   	   	  'MENU12'=>array("label"=>"CONFIGURACOES","uri"=>"/"));
			
		}
		
		if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$result = array( 
				  'MENU01'=>array("label"=>"VENDASC","uri"=>"/"),
		          'MENU02'=>array("label"=>"PAGAMENTOS","uri"=>"/"),
		   	   	  'MENU03'=>array("label"=>"COMPRAS","uri"=>"/"),
		   	   	  'MENU04'=>array("label"=>"ESTOQUE","uri"=>"/"),
		          'MENU05'=>array("label"=>"ENGENHARIAC","uri"=>"/"),
			      'MENU06'=>array("label"=>"PRODUCAOC","uri"=>"/"), 
		   	   	  'MENU07'=>array("label"=>"QUALIDADE","uri"=>"/"),
		   	   	  'MENU08'=>array("label"=>"CONTABILIDADE","uri"=>"/"),
		   	   	  'MENU09'=>array("label"=>"RH","uri"=>"/"),
		   	   	  'MENU10'=>array("label"=>"B2B","uri"=>"/"),
		   	   	  'MENU11'=>array("label"=>"TREINAMENTO","uri"=>"/"),
		   	   	  'MENU12'=>array("label"=>"CONFIGURACOES","uri"=>"/"));
			
		}
				
		if($cliente[0]['IND_COM_SERV'] == "S")
		{
			$result = array( 
			 	  'MENU01'=>array("label"=>"VENDASS","uri"=>"/"),
		          'MENU02'=>array("label"=>"PAGAMENTOS","uri"=>"/"),
		   	   	  'MENU03'=>array("label"=>"COMPRAS","uri"=>"/"),
		   	   	  'MENU04'=>array("label"=>"ESTOQUE","uri"=>"/"),
		          'MENU05'=>array("label"=>"ENGENHARIAS","uri"=>"/"),
			      'MENU06'=>array("label"=>"PRODUCAOS","uri"=>"/"), 
		   	   	  'MENU07'=>array("label"=>"QUALIDADE","uri"=>"/"),
		   	   	  'MENU08'=>array("label"=>"CONTABILIDADE","uri"=>"/"),
		   	   	  'MENU09'=>array("label"=>"RH","uri"=>"/"),
		   	   	  'MENU10'=>array("label"=>"B2B","uri"=>"/"),
		   	   	  'MENU11'=>array("label"=>"TREINAMENTO","uri"=>"/"),
		   	   	  'MENU12'=>array("label"=>"CONFIGURACOES","uri"=>"/"));
		}
		$list = $this->fetchAll($select);   
	    $translate = Zend_Registry::get('Zend_Translate'); 
		foreach ($list as $row){
			$row=$this->decrypt($row);
			foreach ($result as $k=>$v){
				if ($row[$k]=='S' && in_array($k,$menuacess)){
				  $recurso = explode('_',$row['RECURSO']);	
				  $result[$k]['pages'][]=array('label'=>$row['ORDENACAO'].'-'.$translate->translate($row['ROTULO_MENU']),"module"=>$recurso[0],'controller'=>$recurso[1],'action'=>$recurso[2]);
				}
			}




			
		}
		//Zend_Debug::dump($result);//die();
		return $result;	
	}	
	public function getAccessController($user){
		$menuacess=array();
		if ($user['M1']=='S') $menuacess[]='MENU01';
		if ($user['M2']=='S') $menuacess[]='MENU02';
		if ($user['M3']=='S') $menuacess[]='MENU03';
		if ($user['M4']=='S') $menuacess[]='MENU04';
		if ($user['M5']=='S') $menuacess[]='MENU05';
		if ($user['M6']=='S') $menuacess[]='MENU06';
		if ($user['M7']=='S') $menuacess[]='MENU07';
		if ($user['M8']=='S') $menuacess[]='MENU08';
		if ($user['M9']=='S') $menuacess[]='MENU09';
		if ($user['M10']=='S') $menuacess[]='MENU10';
		if ($user['M11']=='S') $menuacess[]='MENU11';
		if ($user['M12']=='S') $menuacess[]='MENU12';
		if (count($menuacess)==0)
		   return array();
		   		
		$session = new Zend_Session_Namespace('processo');
		$select = $this->select(true);
		$select->join('filedoc2','filedoc.id=filedoc2.id_file',array())
		->where("DISPONIVEL = 'S'")
		->where("'S' in (".implode(',', $menuacess).")")
		->where("filedoc2.id_processo=?",intval($session->proc));
		if ( $user['ACESSORESTRITO']=='N' )
			$select->where(" 'S' in (MENU_IND) ");
		if ( $user['ACESSORESTRITO']=='P' )
			$select->where(" 'S' in (MENU_ADM,MENU_IND) ");			
		$list = $this->fetchAll($select);   
		$pages = array();
		foreach ($list as $row){
			$row=$this->decrypt($row);
			$recurso = explode('_',$row['RECURSO']);
			$pages[] = @$recurso[0].'_'.@$recurso[1];
		}
		return $pages;
	}
	
	public function __construct($config = array()) {
			parent::__construct($config);
			$registry = Zend_Registry::getInstance();
			$this->_setAdapter($registry->get('db3'));
		}
	
	
}
?>