<?php

class serv_Model_DbTable_Faturapendenteinter extends Zsam_Db_Table {

	protected $_name = 'faturapendenteinter';

	var $_restrict   = "BAIXA IS NULL";

 	var $_conf = array(
			"NUMERO" 						=> array('grid' => true,'edit' => 'N'),
			"EMPRESA" 						=> array('grid' => true,'edit' => 'N', 'validate' => 'Cisweb_Validate_Contratoexiste'),
 			"PRODUTO"						=> array(),
			"DATA" 							=> array('grid' => true,'edit' => 'N'),
 			'NFES_OU_FATURA' 				=> array('editlevel' => 3,'title'=>'NFES_FATURA_NF_COM','VP' => 'FATURA,NFES,NF_COM'),
			"CFOP" 							=> array('edit' => 'N'),
			"DESCR_CFOP" 					=> array('edit' => 'N'),
 			"CONTRATO" 						=> array('grid' => true,'edit' => 'N'),
			"CLIENTE" 						=> array('edit' => 'N'),
			"NOME_CLI" 						=> array('grid' => true,'edit' => 'N'),
			"CNPJ_CLI" 						=> array('edit' => 'N'),
 			"IE_CLI"						=> array('edit' => 'N'),
			"TOTAL" 						=> array('grid' => true,'editlevel' => 3),
 			"FORMA_ENVIO" 					=> array('VP' => array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO'), 'editlevel' => 3),
 			"BANCO"		 					=> array('editlevel' => 3),
 			"IMPRESSAO" 					=> array('edit' => 'N'),
 			"BAIXA" 						=> array('edit' => 'N'),
			"PERIODO_NFSPAPEL" 				=> array('edit'=>'N','case'=>'NONE','editlevel' => 3),
 			"PERIODO_DE_NFSPAPEL" 			=> array('editlevel' => 3),
 			"PERIODO_ATE_NFSPAPEL" 			=> array('editlevel' => 3),
			"NFSPAPEL_MODELO" 				=> array('editlevel' => 3),
 			'FATURA_MODELO' 				=> array(),
			"VENCIMENTO" 					=> array('editlevel' => 3),
			"DATA_ALTERACAO" 				=> array('edit' => 'N'),
			"FUNC_ALTERACAO" 				=> array('edit' => 'N'),
			"REVISAO" 						=> array('edit' => 'N'),
			"DATASINC" 						=> array('edit' => 'N'),
			"GRID" 							=> array('edit' => 'N')
       );

        protected $_referenceMap = array(
	        'EMPRESA' => array(
	            'columns' 		=> 'EMPRESA',
	            'refTableClass' => 'core_Model_DbTable_Empresa',
	            'refColumns' 	=> 'CODIGO',
	            'refTitle' 		=> 'EMPRESA'
	        ),
        		
       		'PRODUTO' => array(
   				'columns' 		=> 'PRODUTO',
  				'refTableClass' => 'serv_Model_DbTable_Servico',
   				'refColumns' 	=> 'CODIGO',
   				'refTitle' 		=> 'DESCRICAO'//nao alterar .. campo para aparecer o nome...
      		),

        	'CLIENTE' => array(
	            'columns' 		=> 'CLIENTE',
	            'refTableClass' => 'serv_Model_DbTable_Cliente',
	            'refColumns' 	=> 'CODIGO',
	            'refTitle' 		=> 'CLIENTE'
        	),

        	'NFSPAPEL_MODELO' => array(
	            'columns' 		=> 'NFSPAPEL_MODELO',
	            'refTableClass' => 'serv_Model_DbTable_Nfspapelmodelo',
	            'refColumns' 	=> 'ID_NFPAPEL',
	            'refTitle' 		=> 'NFSPAPEL_MODELO'
        	),

			'CFOP' => array(
				'columns' 		=> 'CFOP',
				'refTableClass' => 'core_Model_DbTable_Cfop',
				'refColumns' 	=> 'CODIGO',
				'refTitle' 		=> 'CFOP'
       		),

			'BANCO' => array(
        		'columns' 		=> 'BANCO',
        		'refTableClass' => 'core_Model_DbTable_Banco',
        		'refColumns' 	=> 'CODIGO',
        		'refTitle' 		=> 'BANCO'
        	),

			'FATURA_MODELO' => array(
				'columns' 		=> 'FATURA_MODELO',
				'refTableClass' => 'serv_Model_DbTable_Faturamodelo',
				'refColumns' 	=> 'ID_FATURA',
				'refTitle' 		=> 'ID_FATURA'
			),

    	);

        public function __construct(){

        	$controller      = Zend_Controller_Front::getInstance()->getRequest();
        	$nome_controller = $controller->getControllerName(); //pegar a controladora
        	$auth 			 = Zend_Auth::getInstance();

        	if ($auth->hasIdentity()) {
        		$user   = $auth->getStorage()->read();
        		$funcao = @$user['FUNCAO'];
        		$id     = @$user['ID'];
        		$nome   = @$user['NOME'];
        		$level  = @$user['NIVEL'];
        	}

        	if($nome_controller == 'faturapendenteinter')
        	{
        		if($level >= 3) {

        			$this->_conf['EMPRESA']['edit'] 			= 'S';
        			$this->_conf['CONTRATO']['edit'] 			= 'S';
        			$this->_conf['DATA']['edit'] 				= 'S';
        			$this->_conf['CFOP']['edit'] 				= 'S';
        			$this->_conf['DESCR_CFOP']['edit'] 			= 'S';
        			$this->_conf['CLIENTE']['edit'] 			= 'S';
        			$this->_conf['TOTAL']['edit']	 			= 'S';
        			$this->_conf['PERIODO_NFSPAPEL']['edit']	= 'S';
        			$this->_conf['NFSPAPEL_MODELO']['edit']		= 'S';
        			$this->_conf['VENCIMENTO']['edit']	 		= 'S';

        			$this->_conf['CLIENTE']['NULLABLE'] 		= false;
        			$this->_conf['DATA']['NULLABLE']	 		= false;
        			$this->_conf['TOTAL']['NULLABLE']	 		= false;
        			$this->_conf['VENCIMENTO']['NULLABLE']	 	= false;

        			$this->_conf['CLIENTE']['autocomplete']		= 'Y';
        		}
        	}

        	if($nome_controller == 'faturamensalinter')
        	{
        		if($level >= 3)
        		{
        			$this->_conf['PERIODO_DE_NFSPAPEL']['NULLABLE'] 		= false;
        			$this->_conf['PERIODO_ATE_NFSPAPEL']['NULLABLE']	 	= false;
        			$this->_conf['PRODUTO']['edit']						 	= 'N';
        		}
        	}

        	parent::__construct();
        }


        public function atualiza_Periodos()
        {
        	$dados = $this->getAdapter()->fetchAll($this->select());

        	foreach ($dados as $k => $v)
        	{
        		if (($v['PERIODO_DE_NFSPAPEL'] == '' && $v['PERIODO_ATE_NFSPAPEL'] == '') && $v['PERIODO_NFSPAPEL'] != '')
        		{
        			$exp 							= explode("ate", $v['PERIODO_NFSPAPEL']);
        			$periodo_de  					= explode("/",trim($exp[0]));
        			$periodo_ate 					= explode("/",trim($exp[1]));
        			$data['PERIODO_DE_NFSPAPEL']  	= $periodo_de[2].'-'.$periodo_de[1].'-'.$periodo_de[0];
        			$data['PERIODO_ATE_NFSPAPEL']  	= $periodo_ate[2].'-'.$periodo_ate[1].'-'.$periodo_ate[0];
					$where = "NUMERO = '{$v['NUMERO']}'";
        			$this->update($data, $where);
        		}
        	}
        }
        
	public function beforeInsert(array $data){
		
		/*Verifica se contrato � v�lido*/
		$table_itens 			= new Cisweb_Db_Abstract("locacaointeritens");
		$table_locacao_inter	= new Cisweb_Db_Abstract("locacaointer");
		
		$contrato 				= explode("/", @$data['CONTRATO']);
		$contrato_valido 		= false;
		$cliente				= $data['CLIENTE'];
		
		if(count($contrato) == 2){
				
			$select 			 = $table_locacao_inter->select();
			$select 			 = $select->where("NUMERO = ?",$contrato[0]);
			$select 			 = $select->where("EMPRESA = ?", $contrato[1]);
			$select 			 = $select->where("TIPO = 'P'");
			$dados_locacao_inter = $table_locacao_inter->fetchAll($select)->toArray();
			$dados_locacao_itens = $table_itens->select();
			$dados_locacao_itens = $dados_locacao_itens->where("DATA_CANCELAMENTO IS NULL");
			$dados_locacao_itens = $dados_locacao_itens->where("NUMERO  = ?",  $contrato[0]);
			$dados_locacao_itens = $dados_locacao_itens->where("EMPRESA = ?", $contrato[1]);
			$dados_locacao_itens = $dados_locacao_itens->where("TIPO = 'P'");
			$dados_locacao_itens = $table_itens->fetchAll($dados_locacao_itens)->toArray();
				
			$total = 0;
			foreach ($dados_locacao_itens as $k => $v){
		
				$total += $v['TOTALITEM'];
			}
				
			if(count($dados_locacao_inter) > 0 && count($dados_locacao_itens) > 0){
				$contrato_valido = true;
				$cliente		 = $dados_locacao_inter[0]['CLIENTE'];
			}
		}
		
		
		/*Atualiza campos do cliente*/
		$table_cliente 		= new Cisweb_Db_Abstract("cliente");
		$dados_cliente  	= $table_cliente->find($cliente)->toArray();
		
		$data['NOME_CLI'] 	= $dados_cliente[0]['NOME'];
		$data['CNPJ_CLI']	= $dados_cliente[0]['CNPJ'];
		$data['IE_CLI']		= $dados_cliente[0]['IE'];
		
		if($contrato_valido){
			
			$data['EMPRESA']		= $dados_locacao_inter[0]['EMPRESA'];
			$data['CLIENTE'] 		= $cliente;
			$data['BANCO']			= $dados_locacao_inter[0]['BANCO'];
			$data['FORMA_ENVIO']	= $dados_locacao_inter[0]['FORMA_ENVIO'];
			$data['TOTAL']			= $total;
		}	
		
		return parent::beforeInsert($data);
	}
}

?>