<?php

class serv_Model_DbTable_Zcliente extends Zsam_Db_Table {

	protected $_name = 'zcliente';

	var $_conf = array(
		"ITEM_ID" 				=> array(),
		"USUARIO" 				=> array(),
		"TABELA" 				=> array('VP' => array('NFE'=>'NFe','FATURALOC'=>'FATURALOC','FATURAINTER'=>'FATURAINTER','FATURASERV'=>'FATURASERV','FATURAOUTROS' => 'FATURAOUTROS','NFSPAPEL'=>'NFSPAPEL','NFESERVICO' => 'NFESERVICO')),
		"DEPTO" 				=> array(),
		"CONTRATO" 				=> array(),
		"NF" 					=> array(),
		"EMPRESA1" 				=> array(),
		"DESCRICAO" 			=> array(),
		"DATA_EMISSAO" 			=> array(),
		"CODIGO_CLIENTE" 		=> array(),
		"NOME" 					=> array(),
		"CNPJ" 					=> array(),
		"VENDEDOR" 				=> array(),
		"NUM_TRANSACAO"			=> array(),
		"VALOR_TOTAL" 			=> array(),
		"ULTIMA_PROSPEC"		=> array(),
		"CIDADE" 				=> array(),
		"ESTADO" 				=> array(),
		"REPRESENTANTE" 		=> array(),
		"VALOR" 				=> array(),
		"TIPO_PESSOA" 			=> array('VP' => array("F" => "Física", "J" => "Jurídica")),
		"DATA_ULTIMO_ORCAMENTO" => array(),
		"DATA_PREPARACAO" 		=> array(),
	);

	var $_referenceMap = array(

			'EMPRESA1' => array(
					'columns'           => 'EMPRESA1',
					'refTableClass'     => 'core_Model_DbTable_Empresa',
					'refColumns'        => 'CODIGO',
					'refTitle'          => 'EMPRESA'
			),

			'DEPTO' => array(
					'columns'           => 'DEPTO',
					'refTableClass'     => 'core_Model_DbTable_Depto',
					'refColumns'        => 'DEPARTAMENTO',
					'refTitle'          => 'DEPTO'
			),


			'CODIGO_CLIENTE' => array(
					'columns'           => 'CODIGO_CLIENTE',
					'refColumns'        => 'CODIGO',
					'refTitle'          => 'CLIENTE'
			),

			'CIDADE' => array(
					'columns'           => 'CIDADE',
					'refTableClass'     => 'core_Model_DbTable_Cidade',
					'refColumns'        => 'ID',
					'refTitle'          => 'CIDADE'
			),

			'ESTADO' => array(
					'columns'           => 'ESTADO',
					'refTableClass'     => 'core_Model_DbTable_Estado',
					'refColumns'        => 'UF',
					'refTitle'          => 'ESTADO'
			),

	);

	public function __construct()
	{
		parent::__construct();
		
		$controller      		= Zend_Controller_Front::getInstance()->getRequest();
		$nome_action     		= $controller->getActionName();
		$nome_controller     	= $controller->getControllerName();
		
		$cliente = Zend_Registry::get('Cliente');

		if(@$cliente[0]['IND_COM_SERV'] == "I"){
			$this->_referenceMap['CODIGO_CLIENTE']['refTableClass'] = "ind_Model_DbTable_Cliente";
		}

		else if(@$cliente[0]['IND_COM_SERV'] == "C"){
			$this->_referenceMap['CODIGO_CLIENTE']['refTableClass'] = "com_Model_DbTable_Cliente";
		}

		else{
			$this->_referenceMap['CODIGO_CLIENTE']['refTableClass'] = "ind_Model_DbTable_Cliente";
		}
	}
}
?>