<?php
/**
 * Plugin d'authentification
 * 
 * Largement inspiré de :
 * http://julien-pauli.developpez.com/tutoriels/zend-framework/atelier/auth-http/?page=modele-MVC
**/

class Zsam_Auth_Plugin extends Zend_Controller_Plugin_Abstract	{
	/**
	 * @var Zend_Auth instance 
	 */
	private $_auth;
	
	/**
	 * @var Zend_Acl instance 
	 */
	private $_acl;
	

	const FAIL_AUTH_MODULE     = 'default';
	const FAIL_AUTH_ACTION     = 'login';
	const FAIL_AUTH_CONTROLLER = 'auth';

	const FAIL_ACL_MODULE     = 'default';
	const FAIL_ACL_ACTION     = 'deny';
	const FAIL_ACL_CONTROLLER = 'auth';
	
	/**
	 * Constructeur
	 */
	public function __construct(Zend_Acl $acl)	{
		$this->_acl  = $acl ;
		$this->_auth = Zend_Auth::getInstance() ;
	}
	

	public function preDispatch(Zend_Controller_Request_Abstract $request)	{

		$role =  Zend_Registry::get('role');
		if ($role == 'admin') return;
		
		$module 	= $request->getModuleName() ;
		$controller = $request->getControllerName() ;
		$action     = $request->getActionName() ;
		
		$front = Zend_Controller_Front::getInstance() ;
		$default = $front->getDefaultModule() ;
		
		// compose le nom de la ressource
		if ($module == $default)	{
			$resource = $controller ;
		} else {
			$resource = $module.'_'.$controller ;
		}
        $resource=strtolower($resource);
	    // est-ce que la ressource existe ?
		if (!$this->_acl->has($resource)) {
		  $resource = null;
		}

		if (!$this->_acl->isAllowed($role, $resource, $action)) {
			if (!$this->_auth->hasIdentity()) {
				$module = self::FAIL_AUTH_MODULE ;
				$controller = self::FAIL_AUTH_CONTROLLER ;
				$action = self::FAIL_AUTH_ACTION ;
			} else {
				$module = self::FAIL_ACL_MODULE ;
				$controller = self::FAIL_ACL_CONTROLLER ;
				$action = self::FAIL_ACL_ACTION ;
			}
		}

		$request->setModuleName($module) ;
		$request->setControllerName($controller) ;
		$request->setActionName($action) ;
	}
	
	static function verifica_permissao($page){
		if (Zend_Registry::get('role') == 'admin')
		    return true;
		    
	    $front = Zend_Controller_Front::getInstance() ;
		$default = $front->getDefaultModule() ;
		
		if ($page->getResource) {
		    $resource = $page->getResource() ;
		    $action     = $page->getPrivilege() ;
		} else {
		   $module 	= $page->get('_module') ;
		   $controller = $page->get('_controller') ;
		   $action     = $page->get('_action') ;
			if ($module == $default or $module == "")	{
				$resource = $controller ;
			} else {
				$resource = $module.'_'.$controller ;
			}   
		}
		
		$resource=strtolower($resource);
	    // est-ce que la ressource existe ?
		$acl = Zend_Registry::get('zend_acl');	
		if (!$acl->has($resource)) {
		  $resource = "";
		}
		if ( $resource == "" )
		    return true;
		else
        {		
            $auth = Zend_Auth::getInstance() ;
            return $acl->isAllowed(Zend_Registry::get('role'), $resource, $action);
		}
		
	
	}
}