<?php

class Zsam_Controller_Base extends Zend_Controller_Action {

    protected $campos = array();
    protected $filtro;
    protected $charEncoding = 'UTF-8';
    protected $model;
    protected $titulo = array();
    protected $corpo = array();

    public function pdf($sql) {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();

        $pdf = new Zend_Pdf();


        $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
        $pdf->pages[] = $page;
        if (empty($this->titulo))
            $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
        else
            $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontTitulo()), $this->getSizeTitulo());

        /* Configuração das variáveis para controle de largura(x) e altura(y) da página */
        $x = 70;
        $y = 780;
        $tamanhoCampos = 510 / sizeof($this->campos['linha1']);
        #Contador de páginas

        for ($r = 0; $r < sizeof($sql); $r++) {
            foreach ($this->campos as $k => $v) {

                if ($y <= 0) {
                    $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                    $pdf->pages[] = $page;
                    $x = 70;
                    $y = 750;
                }
                $tamanhoCampos = (510 / sizeof($v)) * 1.3;

                $tCampoFixo = $tamanhoCampos;

                $aCampo = $tCampoFixo;

                $linha = '';
                # a variável maiorLinha serve para cálcular qual foi a entrada que ocupou mais linhas.
                $maiorLinha = 0;

                for ($j = 0; $j < sizeof($v); $j++) {
                    /* Aqui eu monto a primeira linha, primeiro o nome de cada campo */
                    
                    $coluna = $aCampo * $j;
                    
                    if (($aCampo * $j) > 510){
                        $y-=20;
                        $coluna = $aCampo;
                        
                    }

                    if (is_numeric(key($v))) {
                        if ($j == 0) {
                            $maiorLinha = 0;
                            $tlinhas = array();
                            if (empty($this->titulo))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontTitulo()), $this->getSizeTitulo());
                            
                            $page->drawTextBlock(current($v) . ' :', 70, $y, 100);
                            //$this->_helper->getHelper('TratarTexto')->tratar($page, current($v) . ' :', 20, 70, $y, 10);                        
                            
                            if (empty($this->campos))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontCampos()), $this->getSizeCampos());
                            
                            $page->drawTextBlock($sql[$r][current($v)], 70, $y - 20, 20);
                            $tlinhas = $page->_wrapText($sql[$r][current($v)], 110);
                        }else {
                            if (empty($this->titulo))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontTitulo()), $this->getSizeTitulo());
                            
                            $this->_helper->getHelper('TratarTexto')->tratar($page, current($v) . ' :', 20,$coluna , $y, 10);
                            //$linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $sql[$r][current($v)], 20, ($aCampo * $j), $y-20, 10);                                                       
                            
                            if (empty($this->campos))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontCampos()), $this->getSizeCampos());
                            
                            $page->drawTextBlock($sql[$r][current($v)], $coluna, $y - 20, 120);
                            $tlinhas = $page->_wrapText($sql[$r][current($v)], 110);
                        }
                        $aCampo = $tCampoFixo;
                        next($v);
                    } else {
                        if ($j == 0) {
                            $tlinhas = array();
                            $maiorLinha = 0;
                            
                            if (empty($this->titulo))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontTitulo ()), $this->getSizeTitulo ());
                            
                            $page->drawTextBlock(key($v) . ' :', 70, $y, current($v));
                            //$linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $sql[$r][key($v)], $sql[$r][current($v)],70, $y-20, 10);
                                                        
                            if (empty($this->campos))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontCampos()), $this->getSizeCampos());
                            
                            $page->drawTextBlock($sql[$r][key($v)],70, $y-20, current($v));
                            
                            $tlinhas = $page->_wrapText($sql[$r][key($v)], 110);
                        } else {
                            
                            if (empty($this->titulo))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontTitulo()), $this->getSizeTitulo());
                            
                            $page->drawTextBlock(key($v) . ' :', $coluna, $y, current($v));
                            //$linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $sql[$r][key($v)], $sql[$r][current($v)], ($aCampo * $j), $y-20, 10);
                            
                            if (empty($this->campos))
                                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA), 10);
                            else
                                $page->setFont(Zend_Pdf_Font::fontWithName($this->getFontCampos()), $this->getSizeCampos());
                            
                            $page->drawTextBlock($sql[$r][key($v)], $coluna, $y, current($v));
                            $tlinhas = $page->_wrapText($sql[$r][key($v)], 110);
                        }
                        $aCampo = current($v);
                        next($v);
                    }
                    $line_height = $page->getLineHeight();
                    $maiorLinha = (!empty($tlinhas) && count($tlinhas) > $maiorLinha) ? count($tlinhas) : $maiorLinha;
                }


                reset($v);
                $y -= 20 + $line_height * $maiorLinha;

                $line_height = $page->getLineHeight();

                $fim = array_diff($v, end($this->campos));
                if (empty($fim)) {
                    $page->drawLine(70, $y - 5, 580, $y - 5);
                    $y -= 30;
                }

                #  Aqui eu retiro 20 da variável y para que ele desça uma linha aproximadamente, lembrando que o zend pdf faz o cálculo do espaço página em pontos, não em pixels.


                /* Verifco se existe a necessidade de criar uma nova página */
                if ($y <= 0) {
                    $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                    $pdf->pages[] = $page;
                    $x = 70;
                    $y = 780;
                    $tamanhoCampos = 510 / sizeof($v);
                }

                #  Desço mais uma linha
            }
        }
        //$page->drawText($texto, 0, 842-10);842x595

        foreach ($pdf->pages as $k) {
            if (empty($this->titulo))
                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
            else
                $page->setFont(Zend_Pdf_Font::fontWithName($this->titulo['font']), $this->titulo['size']);
            $this->_helper->getHelper('Header')->montaHeader($page, key($k) + 1, count($pdf->pages));
        }

        try {
            $pdfData = $pdf->render();
        } catch (Exception $e) {
            echo $e->message();
        }
        header("Content-Disposition: attachment; filename=relatorio.pdf");
        header("Content-type: application/x-pdf");
        echo $pdfData;
        exit;
    }

    public function setCampos($cam) {
        return $this->campos = $cam;
    }

    public function setTitulo($tit) {
        $this->titulo = $tit;
    }

    public function setCorpo($corpo) {
        $this->corpo = $corpo;
    }
    
    public function getFontCampos(){
        return $this->corpo['font'];
    }
    
    public function getSizeCampos(){
        return $this->corpo['size'];
    }

    public function getFontTitulo(){
        return $this->titulo['font'];
    }
    
    public function getSizeTitulo(){
        return $this->titulo['size'];
    }
    public function filtrarResultado($sql, $campo) {
        $resultados = array();
        foreach ($sql as $k => $v) {
            if (in_array($v, $campo)) {
                $resultados["$v"] = $v;
                next($campo);
            }
        }

        return $resultados;
    }

}

?>