<?php

class especial_Model_DbTable_Programaveiculoitem extends Zsam_Db_Table {

	/**
	 * The default table name
	 */

	protected $_name = 'progrveicitens';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','VEICULO');

	var $_conf = array(
			'CLIENTE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'			=> array('edit' => 'N'),
			'NUM_ITEM' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
            'ID'					=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'VEICULO' 				=> array('autocomplete'=>'Y'),
			'MODELO' 				=> array('autocomplete'=>'Y'),
			'PLACA' 				=> array(),
			'COR' 					=> array(),
			'ANO_MODELO' 			=> array("VP"=> array(2013=>'2013',2012=>'2012',2011=>'2011',2010=>'2010',2009=>'2009',2008=>'2008',2007=>'2007',2006=>'2006',2005=>'2005',2004=>'2004',2003=>'2003',2002=>'2002',2001=>'2001',2000=>'2000',1999=>'1999',1998=>'1998',1997=>'1997',1996=>'1996',1995=>'1995',1994=>'1994',1993=>'1993',1992=>'1992',1991=>'1991',1990=>'1990',1989=>'1989',1988=>'1988',1987=>'1987',1986=>'1986',1985=>'1985',1984=>'1984',1983=>'1983',1982=>'1982',1981=>'1981',1980=>'1980',1979=>'1979',1978=>'1978',1977=>'1977',1976=>'1976',1975=>'1975')),
			'DESCRICAO_ITEM_NOVO'	=> array('edit' => 'N'),//nao esta sendo usado seria para cadastrar item novo
			'COMPRA_OU_VENDA'		=> array('edit' => 'N','VP' => array('1'=> 'VENDA', '-1' => 'COMPRA')),
	        'CFOP' 					=> array('edit' => 'N'),
	        'QUANTIDADE' 			=> array('edit' => 'N','DEFAULT'=>'1','NULLABLE' => false),
			'DATANECESSIDADE' 		=> array('edit' => 'N'),
			'PRECO_UNITARIO' 		=> array('edit' => 'S','NULLABLE' => false),
			'PRECO_CUSTO' 			=> array('edit' => 'N','level'=>5),
			'PRECO_BASE' 			=> array('edit' => 'N'),
	        'PRECO_TOTAL_ITEM'		=> array('edit' => 'N'),
			'BAIXA' 				=> array('edit' => 'N'),
	        'UNI'					=> array('edit' => 'N'),
	        'NCM'					=> array('edit' => 'N'),
	        'STICMS'				=> array('edit' => 'N'),
	        'ORIGEM_SIT_TRIBUTARIA'	=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_ICMS'	=> array('edit' => 'N'),
	        'PERCENTUAL_REDUCAO_BC_ICMS'=> array(),
	        'MODALIDADE_BC_ICMS'	=> array(),
	        'ALIQUOTA_ICMS'			=> array('edit' => 'N'),
	        'TOTAL_ICMS'			=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_ICMS_ST'=> array('edit' => 'N'),
			'MVA_ST' 				=> array('edit' => 'N'),
			'MODALIDADE_BC_ICMSST'	=> array('edit' => 'N'),
	        'ALIQUOTA_ICMS_ST'		=> array('edit' => 'N'),
	        'TOTAL_ICMS_ST'			=> array('edit' => 'N'),
	        'STIPI'					=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_IPI'	=> array('edit' => 'N'),
	        'ALIQUOTA_IPI'			=> array('edit' => 'N'),
	        'TOTAL_IPI'				=> array('edit' => 'N'),
	        'STPIS'					=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_PIS'	=> array('edit' => 'N'),
	        'ALIQUOTA_PIS'			=> array('edit' => 'N'),
	        'TOTAL_PIS'				=> array('edit' => 'N'),
	        'STCOFINS'				=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_COFINS'=> array('edit' => 'N'),
	        'ALIQUOTA_COFINS'		=> array('edit' => 'N'),
	        'TOTAL_COFINS'			=> array('edit' => 'N'),
			'INFORMACAO_ADICIONAL'	=> array('help'=>'help_quebrar_linha_com_;'),
	        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
			'DATA_ALTERACAO' 		=> array('edit' => 'N'),
			'REVISAO' 				=> array('edit' => 'N'),
			'DATASINC' 				=> array('edit' => 'N')
	);
	var $_referenceMap = array(
			'VEICULO' => array(
					'columns' 		=> 'VEICULO',
					'refTableClass' => 'especial_Model_DbTable_Veiculo',
					'refColumns' 	=> 'ID',
					'refTitle' 		=> 'VEICULO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),
			
			'COR' => array(
					'columns'           => 'COR',
					'refTableClass'     => 'especial_Model_DbTable_Veiculocor',
					'refColumns'        => 'ID',
					'refTitle'          => 'COR'
			),
			

			/*'STICMS' => array(
					'columns' 		=> 'STICMS',
					'refTableClass' => 'core_Model_DbTable_Sticms',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STICMS'
			),
			'STIPI' => array(
					'columns' 		=> 'STIPI',
					'refTableClass' => 'core_Model_DbTable_Stipi',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STIPI'
			),
			'STPIS' => array(
					'columns' 		=> 'STPIS',
					'refTableClass' => 'core_Model_DbTable_Stpis',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STPIS'
			),
			'STCOFINS' => array(
					'columns' 		=> 'STCOFINS',
					'refTableClass' => 'core_Model_DbTable_Stpis',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STCOFINS'
			),


			'ORIGEM_SIT_TRIBUTARIA' => array(
					'columns'           => 'ORIGEM_SIT_TRIBUTARIA',
					'refTableClass'     => 'core_Model_DbTable_Sittrib',
					'refColumns'        => 'CODIGO',
					'refTitle'          => 'CLASFISCAL'
			),*/

	);
	public function __construct()
	{
		parent::__construct();

		//$this->_restrict = "CODIGO_CLIENTE = ".$id;

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		
		if ($nome_controller == 'programaveiculoitem')
		{
			$this->_conf['CFOP']['NULLABLE'] = false; 
			$this->_conf['VEICULO']['NULLABLE'] = false;
			
		}	
		
		if ($nome_controller == 'programacompraveicitem')
		{

			$this->_conf['MODELO']['NULLABLE'] = false;
			
			$this->_referenceMap['MODELO'] = array(
					'columns'           => 'MODELO',
					'refTableClass'     => 'especial_Model_DbTable_Modelo',
					'refColumns'        => 'ID',
					'refTitle'          => 'MODELO'
			);
		}

	}

	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();

	}
	
	public function validaveiculo($id,$idprog,$cli)
	{
		$dados = $this->getAdapter()->fetchAll($this->select()->where("VEICULO = '$id' AND (CLIENTE <> '$cli' AND ITEM_PROGR <> '$idprog')"));
		
		if (count($dados) != 0)
		{
			return 'N'; // ocupado
		}		
		else 
		{
			return 'S'; // livre
		}	
	
	}
	
	public function buscaveiculo($val)
	{
		$table = new especial_Model_DbTable_Veiculo();
		return $dados = $table->find($val)->current();
	}
	
	public function getCfop($cli,$emp)
	{
		$table_empresa			= new Cisweb_Db_Abstract("empresa");
		$table_cliente			= new Cisweb_Db_Abstract("cliente");
		$table_estado			= new Cisweb_Db_Abstract("estados");
		$table_cidade			= new Cisweb_Db_Abstract("cidades");
		$table_pais				= new Cisweb_Db_Abstract("paises");
		$table_cfop				= new Cisweb_Db_Abstract("cfop");
	
		//Dados da empresa
		$camposemp 				= $table_empresa->find($emp)->current();
		$camposcityemp 			= $table_cidade->find($camposemp['CIDADE'])->current();
		$camposestadoempresa	= $table_estado->find($camposcityemp['UF'])->current();
		$campospaisempresa		= $table_pais->find($camposestadoempresa['PAIS'])->current();
	
		//Dados do cliente
		$camposcli 				= $table_cliente->find($cli)->current();
		$camposcitycli 			= $table_cidade->find($camposcli['CIDADE'])->current();
		$camposestadocliente	= $table_estado->find($camposcitycli['UF'])->current();
		$campospaiscliente		= $table_pais->find($camposestadocliente['PAIS'])->current();
	
	
		if ($camposestadoempresa['PAIS'] != $camposestadocliente['PAIS'])
		{
			$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 6999 AND CODIGO < 8000) AND TIPONF = 'F'"));
	
		}
		elseif($camposcityemp['UF'] != $camposcitycli['UF'])
		{
			$camposcfop = '6102';
	
		}
		else
		{
			$camposcfop = '5102';
	
		}
	
		return $camposcfop;
	}

	public function getCfopsittrib($emp, $cfop)
	{

		$tablecfop  = new core_Model_DbTable_Cfop();
		$tableemp   = new core_Model_DbTable_Empresa();

		$table_icms				= new Cisweb_Db_Abstract("sticms");
		$table_estado			= new Cisweb_Db_Abstract("stipi");
		$table_cidade			= new Cisweb_Db_Abstract("stpis");


		$tab  		= $tablecfop->find($cfop)->current();
		$tabemp  	= $tableemp->find($emp)->current();

		if ($tabemp['REGIME_TRIBUTARIO'] == 3 || $tabemp['REGIME_TRIBUTARIO'] == 4 || $tabemp['REGIME_TRIBUTARIO'] == 13 || $tabemp['REGIME_TRIBUTARIO'] == 14)
		{

			$data['STICMS'] 	= $tab['STICMS'];
			$data['STIPI'] 		= $tab['STIPI'];
			$data['STPIS'] 		= $tab['STPIS'];
			$data['STCOFINS'] 	= $tab['STCOFINS'];

			$tabicms  	= $table_icms->find($tab['STICMS'])->current();

			if  ($tabicms['ALIQUOTA_ICMS'] == 'S')$data['ALIQUOTA_ICMS_EDIT']   = 'S';
			else $data['ALIQUOTA_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_BASE_CALC_ICMS'] == 'S')$data['VALOR_BASE_CALC_ICMS_EDIT']   = 'S';
			else $data['VALOR_BASE_CALC_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_ICMS'] == 'S')$data['VALOR_ICMS_EDIT']   = 'S';
			else $data['VALOR_ICMS_EDIT']   = 'N';
		}
		else
		{

			if (!is_null($tab['ALIQUOTA_DE_CREDITO']))
			{
				$data['ALIQUOTA_ICMS'] 	= $tab['ALIQUOTA_DE_CREDITO'];

			}
			else
			{
				$data['ALIQUOTA_ICMS'] 			= 0.0;

			}

			$data['STICMS'] 	= $tab['STICMS_SIMPLES'];
			$data['STIPI'] 		= $tab['STIPI_SIMPLES'];
			$data['STPIS'] 		= $tab['STPIS_SIMPLES'];
			$data['STCOFINS'] 	= $tab['STCOFINS_SIMPLES'];

		}

		return $data;

	}

	public function beforeInsert(array $data)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programacompraveicitem')
		{
			$data['COMPRA_OU_VENDA'] = '-1';
		}
		
		if ($nome_controller == 'programaveiculoitem')
		{

			$data['COMPRA_OU_VENDA'] = '1';
			
			if ($data['STICMS'] == '60')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
				$data['BASE_CALCULO_ICMSST_RETIDO'] 	= 0.00;
				$data['VALOR_ICMSST_RETIDO'] 			= 0.00;

			}
			if ($data['STICMS'] == '40')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '41')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '50')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STPIS'] == '07')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '07')
			{
				$data['ALIQUOTA_COFINS'] 					= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
				$data['TOTAL_COFINS'] 						= 0.00;

			}

			if ($data['STPIS'] == '08')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '08')
			{
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;

			}

			if ($data['NCM'] != '')
			{
				$table = new Cisweb_Db_Abstract('ncm');
				$ncm   = $table->find($data['NCM'])->current();

				$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $ncm['ICMS_BR'];
				$data['MODALIDADE_BC_ICMS'] 			= $ncm['MODALIDADE_BC_ICMS'];

				if ($data['STICMS'] == '201' || $data['STICMS'] == '10')
				{
					$data['MODALIDADE_BC_ICMSST'] 	= $ncm['MODALIDADE_BC_ICMSST'];
					$data['MVA_ST'] 				= $ncm['ALIQUOTA_ICMS_AC'];
				}
			}
		}
		return parent::beforeInsert($data);
	}


	


	public function calcula_total($dados_item)
	{
		$total = 0;

		foreach ($dados_item as $key => $value)
		{

				$total 		+= $value['PRECO_TOTAL_ITEM'];
		}

		return $total;
	}

	public function beforeUpdate(array $data, $where)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programacompraveicitem')
		{
			$data['COMPRA_OU_VENDA'] = '-1';
		}
		
		if ($nome_controller == 'programaveiculoitem')
		{
		
			$data['COMPRA_OU_VENDA'] = '1';
				
			if ($data['STICMS'] == '60')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
				$data['BASE_CALCULO_ICMSST_RETIDO'] 	= 0.00;
				$data['VALOR_ICMSST_RETIDO'] 			= 0.00;
		
			}
			if ($data['STICMS'] == '40')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
		
			}
		
			if ($data['STICMS'] == '41')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
		
			}
		
			if ($data['STICMS'] == '50')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
		
			}
		
			if ($data['STPIS'] == '07')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;
		
			}
		
			if ($data['STCOFINS'] == '07')
			{
				$data['ALIQUOTA_COFINS'] 					= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
				$data['TOTAL_COFINS'] 						= 0.00;
		
			}
		
			if ($data['STPIS'] == '08')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;
		
			}
		
			if ($data['STCOFINS'] == '08')
			{
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;
		
			}
		
			if (@$data['NCM'] != '')
			{
				$table = new Cisweb_Db_Abstract('ncm');
				$ncm   = $table->find($data['NCM'])->current();
		
				$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $ncm['ICMS_BR'];
				$data['MODALIDADE_BC_ICMS'] 			= $ncm['MODALIDADE_BC_ICMS'];
		
				if ($data['STICMS'] == '201' || $data['STICMS'] == '10')
				{
					$data['MODALIDADE_BC_ICMSST'] 	= $ncm['MODALIDADE_BC_ICMSST'];
					$data['MVA_ST'] 				= $ncm['ALIQUOTA_ICMS_AC'];
				}
			}
		}
		return parent::beforeUpdate($data, $where);

	}

	public function getEmpresa($emp)
	{

		$table = new core_Model_DbTable_Empresa();
		$dados = $table->find($emp)->toArray();

		return $dados[0];
	}

	public function Buscapreco($prod,$cli,$tipo)
	{
		if ($tipo == 'L')
		{

			$table = new core_Model_DbTable_Ativoprodutos();
			$dados = $table->find($prod);
			return $dados;

		}
		elseif ($tipo == 'P')
		{
			$table = new core_Model_DbTable_ProdutoCliente();
			$dados = $table->findMultipleKey(array($prod,$cli));
			return $dados;
		}
	}

	public function impostosAction()
	{

	    die("Jefferson");

	    $id 		= $this->_request->getParam("id");
	    echo json_encode($this->getImposto($id));
	    die();
	}
}
?>