<?php

abstract class Zsam_Validate_CpAbstract extends Zend_Validate_Abstract
{
    /**
     * Tamanho Inválido
     * @var string
     */
    const SIZE = 'tam_cnpj';
 
    /**
     * Números Expandidos
     * @var string
     */
    const EXPANDED = 'digito_expandido';
 
    /**
     * Dígito Verificador
     * @var string
     */
    const DIGIT = 'digito_incorreto';
 
    /**
     * Tamanho do Campo
     * @var int
     */
    protected $_size = 0;
 
    /**
     * Modelos de Mensagens
     * @var string
     */
    protected $_messageTemplates = array(
        self::SIZE     => "Tamanho cnpj inválido",
        self::EXPANDED => "digitos expandidos",
        self::DIGIT    => "dígito incorreto"
    );
 
    /**
     * Modificadores de Dígitos
     * @var array
     */
    protected $_modifiers = array();
 
    /**
    * Validação Interna do Documento
    * @param string $value Dados para Validação
    * @return boolean Confirmação de Documento Válido
    */
    protected function _check($value)
    {
        // Captura dos Modificadores
        foreach ($this->_modifiers as $modifier) {
            $result = 0; // Resultado Inicial
            $size = count($modifier); // Tamanho dos Modificadores
            for ($i = 0; $i < $size; $i++) {
                $result += $value[$i] * $modifier[$i]; // Somatório
            }
            $result = $result % 11;
            $digit  = ($result < 2 ? 0 : 11 - $result); // Dígito
            // Verificação
            if ($value[$size] != $digit) {
                return false;
            }
        }
        return true;
    }
 
    public function isValid($value)
    {
    	// Filtro de Dados
        $data = preg_replace('/[^0-9]/', '', $value);
        // Verificação de Tamanho
        if (strlen($data) != $this->_size) {
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::SIZE, $value),true,true);
			$this->_error(self::SIZE);
        	return false;
        }
        // Verificação de Dígitos Expandidos
        if (str_repeat($data[0], $this->_size) == $data) {
           
		   // echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::EXPANDED, $value),true,true);
            $this->_error(self::EXPANDED);
		    return false;
        }
        // Verificação de Dígitos
        if (!$this->_check($data)) {
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::DIGIT, $value),true,true);
            $this->_error(self::DIGIT);
            return false;
        }
        // Comparações Concluídas
        return true; // Todas Verificações Executadas
    }
 
}