<?php

class Zend_View_Helper_FormItemGrid extends Zend_View_Helper_FormElement {
	
	/**
	 * Generates a 'grid' element.
	 *
	 * @access public
	 *
	 * @param string|array $name If a string, the element name.  If an
	 * array, all other parameters are ignored, and the array elements
	 * are used in place of added parameters.
	 *
	 * @param mixed $value The element value.
	 *
	 * @param array $attribs Attributes for the element tag.
	 *
	 * @return string The element XHTML.
	 */
	public function formItemGrid($name, $value = null, $attribs = null) {
		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$info = $this->_getInfo ( $name, $value, $attribs );
		extract ( $info );
		$rowset = array ();		

		$buttons = $this->view->buttons_items;
		
		$table = new $attribs ['model'] ();
		$table instanceof Zend_Db_Table;

//		Zend_Debug::dump($table->_referenceMap,'A');

		
		$adapter = $table->getAdapter ();
		$var = $table->info ();
		$keys = $var['primary'];


		$idItem = $_SESSION['item']['id'];
		if (isset ( $attribs ['idWhere'] )) {
			if(isset ( $attribs ['valueWhere'] )){
				$idItem = $attribs ['valueWhere'];
			}
			$rowset = $adapter->fetchAll ( $table->select ( false )->from ( $var ['name'], $attribs ['columns'] )->where ( "$attribs[idWhere]" . "=?", $this->view->escape ( $idItem ) ) );
		} else {
			$rowset = $adapter->fetchAll ( $table->select ( false )->from ( $var ['name'], $attribs ['columns'] ) );
		}
				
		$title = $table->getDescribe ();
		$tbl = '';
		if ($controller->getActionName() == 'upd' && @$buttons['insert'] != 'N'){
			$tbl = "<input type='button' class ='gridItemButton' name='buttonAddItem' id='buttonAddItem'  value='".Zsam_Util::showMessage('label_bt_insert', true, false)."' onclick='cisweb_newItens(". $idItem . ");' />";
		}
		$tbl .= "<div id='grid2' class='cisweb_grid_rows'>";
		
		$tbl .= "<table border = '1'><tr>";
		
		foreach ( $attribs ['columns'] as $k ) {
			$tbl .= '<td ><center>' . $k . '</center></td>';
		}
		
		if (@$buttons['edit'] != 'N'){
			$tbl .= '<td><center>'.Zsam_Util::showMessage('label_bt_edit', true, false).'</center></td>';
		}
		if (@$buttons['del'] != 'N'){
			$tbl .= '<td><center>'.Zsam_Util::showMessage('label_bt_delete', true, false).'</center></td>';
		}
		
		$tbl .= '</tr>';
		
		foreach ( $rowset as $ln ) {
			$tbl .= '<tr>';
			
			foreach ( $ln as $k2 => $v ) {
				$tbl .= '<td><center>' . $v . '</center></td>';
			}

			for($i = 1; $i <= count($keys); $i++){
				$v2[] = $ln[$keys[$i]];
			}

			if (@$buttons['edit'] != 'N'){
				$tbl .= "<td width='20px'><input type='button' class ='gridItemButton' name='buttonEditItem' id='buttonEditItem'  value='".Zsam_Util::showMessage('window_edit', true, false)."' onclick='cisweb_editItens(". json_encode($v2) . ");' /></td>";
			}
			if (@$buttons['del'] != 'N'){
				$tbl .= "<td width='20px'><input type='button' class ='gridItemButton' name='buttonDelItem' id='buttonDelItem'  value='".Zsam_Util::showMessage('window_del', true, false)."' onclick='cisweb_delItens(". json_encode($v2) . ");' /></td>";
			}
			$tbl .= '</tr>';
			$v2 = null;
		}
		$tbl .= '</table>';
		$tbl .= '</div>';
		return $tbl;
	}
}
